*** COS 2019 01, last update 2022 12  
           
           
           
program define dq_des_gh1  
           
syntax varlist (max=1 numeric) [if] [in], [thumbs(int 0)] 		///  
			$syntax_datasource_files  $syntax_variablelists														///  
			$syntax_reportformatting																			///  
			$syntax_analysissettings																			///  
			$syntax_debugging																					///  
			$technical_settings  
           
marksample touse, novarlist  
			        
           
           
local indent=`indent'+5  
local adoname "dq_des_gh1"  
local text_i "di as text _n "  					  
           
           
           
local pointer "$`varlist'"         											  
local xmax	=	`=vp_max_`ststrata'_`pointer''  
local xmin	=	`=vp_min_`ststrata'_`pointer''  
           
qui levelsof `varlist'  
if wordcount("`r(levels)'")==0 {  
	exit      
}          
           
local graph_path "`gd'\hist_`ststrata'_`varlist'.png"  
scalar graph_hist_`ststrata'_`pointer'="`graph_path'"  
           
           
           
capture confirm scalar lim_sl_$`pointer'  
if _rc==0 {			  
	local limit=real(subinstr(subinstr(subinstr("`=lim_sl_$`pointer''","<","",.),"=","",.),">","",.))		  
	capture confirm number `limit'  
	if _rc==0 {		  
		*if `limit'>vp_min_`ststrata'_`pointer'  
		local lsl_line `"xline(`limit', lcolor($problemyellow)) text(0 `limit' " lower soft limit", place(ne) color($problemyellow) size(*.8) orientation(vertical))"'		  
		local xmin=min(`limit',`xmin')											  
	}         
	else local lsl_line `"text(0 `=vp_min_`ststrata'_`pointer'' " lower soft limit unreadable", place(ne) color($decentgrey) size(*.7) orientation(vertical))"'  
}          
else local lsl_line `"text(0 `=vp_min_`ststrata'_`pointer'' " lower soft limit not defined", place(ne) color($decentgrey) size(*.7) orientation(vertical))"'  
           
capture confirm scalar lim_su_$`pointer'  
if _rc==0 {  
	local limit=real(subinstr(subinstr(subinstr("`=lim_su_$`pointer''","<","",.),"=","",.),">","",.))		  
	capture confirm number `limit'  
	if _rc==0 {  
		*if `limit'<vp_max_`ststrata'_`pointer'  
		local usl_line `"xline(`limit', lcolor($problemyellow)) text(0 `limit' " upper soft limit", place(nw) color($problemyellow) size(*.8) orientation(vertical))"'			  
		local xmax=max(`limit',`xmax')											  
	}		       
	else local usl_line `"text(0 `=vp_max_`ststrata'_`pointer'' " upper soft limit unreadable", place(nw) color($decentgrey) size(*.7) orientation(vertical))"'  
}	         
else local usl_line `"text(0 `=vp_max_`ststrata'_`pointer'' " upper hard limit not defined", place(nw) color($decentgrey) size(*.7) orientation(vertical))"'  
           
capture confirm scalar lim_hl_$`pointer'  
if _rc==0 {  
	local limit=real(subinstr(subinstr(subinstr("`=lim_hl_$`pointer''","<","",.),"=","",.),">","",.))		  
	capture confirm number `limit'  
	if _rc==0 {  
		*if `limit'>vp_min_`ststrata'_`pointer'  
		local lhl_line `"xline(`limit', lcolor($problemred)) text(0 `limit' " lower hard limit", place(nw) color($problemred) size(*.8) orientation(vertical))"'						  
		local xmin=min(`limit',`xmin')											  
	}         
	else local lhl_line `"text(0 `=vp_min_`ststrata'_`pointer'' " lower hard limit unreadable", place(nw) color($decentgrey) size(*.7) orientation(vertical))"'  
}	         
else local lhl_line `"text(0 `=vp_min_`ststrata'_`pointer'' " lower hard limit not defined", place(nw) color($decentgrey) size(*.7) orientation(vertical))"'  
           
capture confirm scalar lim_hu_$`pointer'  
if _rc==0 {  
	local limit=real(subinstr(subinstr(subinstr("`=lim_hu_$`pointer''","<","",.),"=","",.),">","",.))		  
	capture confirm number `limit'  
	if _rc==0 {  
		*if `limit'<vp_max_`ststrata'_`pointer'  
		local uhl_line `"xline(`limit', lcolor($problemred)) text(0 `limit' "upper hard limit", place(ne) color($problemred) size(*.8) orientation(vertical))"'						  
		local xmax=max(`limit',`xmax')											  
	}	        
	else local uhl_line `"text(0 `=vp_max_`ststrata'_`pointer'' " upper hard limit unreadable", place(ne) color(gs12) size(*.7) orientation(vertical))"'  
}          
else local uhl_line `"text(0 `=vp_max_`ststrata'_`pointer'' " upper hard limit not defined", place(ne) color(gs12) size(*.7) orientation(vertical))"'  
           
           
           
           
           
qui sum `varlist' if `touse' & `varlist'>`=vp_p10_`ststrata'_`pointer'' & `varlist'<`=vp_p90_`ststrata'_`pointer''	  
local correctfactor=0.01+(ln(r(N))/3.5)^3																		  
local binwidth=max(1,trunc(`=vp_levels_`ststrata'_`pointer''/200))												  
if r(sd)>0 local binwidth=min(r(sd)/`correctfactor',`binwidth')													  
local binset "width(`binwidth')"			  
           
*local limitline "limitlines$`pointer'"  
*di `"The graph of limitline is: `limitline'  $`limitline'"'  
*di `"Local design: `uhl_line'"'  
*di `"Local design: `lhl_line'"'  
*di `"Local design: `usl_line'"'  
*di `"Local design: `lsl_line'"'  
local limitline `" `uhl_line' `lhl_line' `usl_line' `lsl_line' "'  
           
local xmin=`xmin'- `=vp_range_`ststrata'_`pointer''/50  
local xmax=`xmax'+ `=vp_range_`ststrata'_`pointer''/50  
           
           
local stepsum=abs((`xmax'-`xmin')/$xhistlabelnumber)  
if `stepsum'>=1 local xlabelformat "%9.0f"  
if `stepsum'>=.1 & `stepsum'<1  local xlabelformat "%9.1f"  
if `stepsum'>=.01 & `stepsum'<.1  local xlabelformat "%9.2f"  
if `stepsum'>=.001 & `stepsum'<.01  local xlabelformat "%9.3f"  
if `stepsum'>=.0001 & `stepsum'<.001  local xlabelformat "%9.4f"  
if `stepsum'<.0001 	 local xlabelformat "%9.5f"  
           
           
if `thumbs'==1 {  
	local size "width($graphthumbswidth) height($graphthumbseheight)"  
	local formatting "legend(off) "  
	local gridsetting=""  
}          
else {	    
	local size "width($graphhalfpagewidth) height($graphhalfpageheight)"  
	local formatting "ytitle("$Percent_1", angle(vertical)) "  
	local gridsetting=", grid"  
}	         
           
capture confirm file "`graph_path'"  
if _rc~=0 | `forcecalc'~=0 {											  
	if (`=vp_levels_`ststrata'_`pointer''>=`histkat')  {  
		qui hist `varlist' if `touse', percent graphregion(margin(vsmall) fcolor($framecolor)) color($fillcolor) lcolor($linecolor) kdensity xtick(#$xhistticknumber `gridsetting') xsc(r(`xmin' `xmax')) xlabel(#$xhistlabelnumber, format(`xlabelformat')) `formatting' `binset' `limitline'  
	}         
	else  {   
		*lab var `varlist' "." 												  
		if `thumbs'==1 {													  
			tempvar nolabelvar  
			qui gen `nolabelvar'=`varlist'  
			local var `nolabelvar'  
		}        
		else local var "`varlist'"  
		qui catplot `var' if `touse', percent recast (hbar) graphregion(fcolor($framecolor)) bar(1, bfcolor($fillcolor) blcolor($linecolor))  blabel(bar, format(%9.`decimals'f)) l1title("") `formatting'  
		*lab var `varlist' "`=varshortlabel_`pointer''"									  
	}	        
	qui graph export "`graph_path'", replace `size'  
           
}	         
           
           
end        
